# - Find Perl libraries
# This module finds if PERL is installed and determines where the include files
# and libraries are. It also determines what the name of the library is. This
# code sets the following variables:
#
#  PERL_INCLUDE_PATH = path to where perl.h is found
#  PERL_EXECUTABLE   = full path to the perl binary
#  PERL_SITESEARCH   = path to the sitesearch install dir
#  PERL_SITELIB      = ...
#  PERL_VENDORARCH
#  PERL_VENDORLIB
#  PERL_ARCHLIB
#  PERL_PRIVLIB
#

SET(PERL_POSSIBLE_LIB_PATHS
  /usr/lib
)

FIND_PATH(PERL_INCLUDE_PATH
  NAMES
    perl.h
  PATHS
    ${PERL_POSSIBLE_INCLUDE_PATHS}
)

FIND_PROGRAM(PERL_EXECUTABLE
  NAMES
    perl
  PATHS
    /usr/bin
    /usr/local/bin
)

IF (PERL_EXECUTABLE)
  EXECUTE_PROCESS(
    COMMAND
      ${PERL_EXECUTABLE} -V:prefix
      OUTPUT_VARIABLE
        PERL_PREFIX_OUTPUT_VARIABLE
      RESULT_VARIABLE
        PERL_PREFIX_RESULT_VARIABLE
  )
  IF (NOT PERL_PREFIX_RESULT_VARIABLE)
    STRING(REGEX REPLACE "prefix='([^']+)'.*" "\\1" PERL_PREFIX_OUTPUT_VARIABLE ${PERL_PREFIX_OUTPUT_VARIABLE})
    SET(PERL_PREFIX ${PERL_PREFIX_OUTPUT_VARIABLE})
  ENDIF (NOT PERL_PREFIX_RESULT_VARIABLE)

  EXECUTE_PROCESS(
    COMMAND
      ${PERL_EXECUTABLE} -V:config
      OUTPUT_VARIABLE
        PERL_VERSION_OUTPUT_VARIABLE
      RESULT_VARIABLE
        PERL_VERSION_RESULT_VARIABLE
  )
  IF (NOT PERL_VERSION_RESULT_VARIABLE)
    STRING(REGEX REPLACE "version='([^']+)'.*" "\\1" PERL_VERSION_OUTPUT_VARIABLE ${PERL_VERSION_OUTPUT_VARIABLE})
    SET(PERL_VERSION ${PERL_CPPFLAGS_OUTPUT_VARIABLE})
  ENDIF (NOT PERL_VERSION_RESULT_VARIABLE)


  EXECUTE_PROCESS(
    COMMAND
      ${PERL_EXECUTABLE} -V:archname
      OUTPUT_VARIABLE
        PERL_ARCHNAME_OUTPUT_VARIABLE
      RESULT_VARIABLE
        PERL_ARCHNAME_RESULT_VARIABLE
  )
  IF (NOT PERL_ARCHNAME_RESULT_VARIABLE)
    STRING(REGEX REPLACE "archname='([^']+)'.*" "\\1" PERL_ARCHNAME_OUTPUT_VARIABLE ${PERL_ARCHNAME_OUTPUT_VARIABLE})
    SET(PERL_ARCHNAME ${PERL_ARCHNAME_OUTPUT_VARIABLE})
  ENDIF (NOT PERL_ARCHNAME_RESULT_VARIABLE)


  SET(PERL_POSSIBLE_INCLUDE_PATHS
    /usr/lib/perl5/${PERL_VERSION}/${PERL_ARCHNAME}/CORE
    /usr/lib/perl/${PERL_VERSION}/${PERL_ARCHNAME}/CORE
    /usr/lib/perl/5.8/CORE
    /usr/lib/perl5/5.8/CORE
  )

  EXECUTE_PROCESS(
    COMMAND
      ${PERL_EXECUTABLE} -V:libperl
    OUTPUT_VARIABLE
      PERL_LIBRARY_OUTPUT_VARIABLE
    RESULT_VARIABLE
      PERL_LIBRARY_RESULT_VARIABLE
  )
  IF (NOT PERL_LIBRARY_RESULT_VARIABLE)
    FOREACH(path ${PERL_POSSIBLE_LIB_PATHS})
      STRING(REGEX REPLACE "libperl='([^']+)'" "\\1" PERL_LIBRARY_OUTPUT_VARIABLE ${PERL_LIBRARY_OUTPUT_VARIABLE})
      SET(PERL_POSSIBLE_LIBRARY_NAME ${PERL_POSSIBLE_LIBRARY_NAME} "${path}/${PERL_LIBRARY_OUTPUT_VARIABLE}")
    ENDFOREACH(path ${PERL_POSSIBLE_LIB_PATHS})
  ENDIF (NOT PERL_LIBRARY_RESULT_VARIABLE)


  EXECUTE_PROCESS(
    COMMAND
      ${PERL_EXECUTABLE} -V:cppflags
    OUTPUT_VARIABLE
      PERL_CPPFLAGS_OUTPUT_VARIABLE
    RESULT_VARIABLE
      PERL_CPPFLAGS_RESULT_VARIABLE
    )
  IF (NOT PERL_CPPFLAGS_RESULT_VARIABLE)
    STRING(REGEX REPLACE "cppflags='([^']+)'.*" "\\1" PERL_CPPFLAGS_OUTPUT_VARIABLE ${PERL_CPPFLAGS_OUTPUT_VARIABLE})
    SET(PERL_EXTRA_C_FLAGS ${PERL_CPPFLAGS_OUTPUT_VARIABLE})
    SEPARATE_ARGUMENTS(PERL_EXTRA_C_FLAGS)
  ENDIF (NOT PERL_CPPFLAGS_RESULT_VARIABLE)


  EXECUTE_PROCESS(
    COMMAND
      ${PERL_EXECUTABLE} -V:installsitesearch
    OUTPUT_VARIABLE
      PERL_SITESEARCH_OUTPUT_VARIABLE
    RESULT_VARIABLE
      PERL_SITESEARCH_RESULT_VARIABLE
  )
  IF (NOT PERL_SITESEARCH_RESULT_VARIABLE)
    STRING(REGEX REPLACE "install[a-z]+='([^']+)'.*" "\\1" PERL_SITESEARCH_OUTPUT_VARIABLE ${PERL_SITESEARCH_OUTPUT_VARIABLE})
    SET(PERL_SITESEARCH ${PERL_SITESEARCH_OUTPUT_VARIABLE})
  ENDIF (NOT PERL_SITESEARCH_RESULT_VARIABLE)


  EXECUTE_PROCESS(
    COMMAND
      ${PERL_EXECUTABLE} -V:installsitelib
    OUTPUT_VARIABLE
      PERL_SITELIB_OUTPUT_VARIABLE
    RESULT_VARIABLE
      PERL_SITELIB_RESULT_VARIABLE
  )
  IF (NOT PERL_SITELIB_RESULT_VARIABLE)
    STRING(REGEX REPLACE "install[a-z]+='([^']+)'.*" "\\1" PERL_SITELIB_OUTPUT_VARIABLE ${PERL_SITELIB_OUTPUT_VARIABLE})
    SET(PERL_SITELIB ${PERL_SITELIB_OUTPUT_VARIABLE})
  ENDIF (NOT PERL_SITELIB_RESULT_VARIABLE)


  EXECUTE_PROCESS(
    COMMAND
      ${PERL_EXECUTABLE} -V:installvendorarch
    OUTPUT_VARIABLE
      PERL_VENDORARCH_OUTPUT_VARIABLE
    RESULT_VARIABLE
      PERL_VENDORARCH_RESULT_VARIABLE
    )
  IF (NOT PERL_VENDORARCH_RESULT_VARIABLE)
    STRING(REGEX REPLACE "install[a-z]+='([^']+)'.*" "\\1" PERL_VENDORARCH_OUTPUT_VARIABLE ${PERL_VENDORARCH_OUTPUT_VARIABLE})
    SET(PERL_VENDORARCH ${PERL_VENDORARCH_OUTPUT_VARIABLE})
  ENDIF (NOT PERL_VENDORARCH_RESULT_VARIABLE)


  EXECUTE_PROCESS(
    COMMAND
      ${PERL_EXECUTABLE} -V:installvendorlib
    OUTPUT_VARIABLE
      PERL_VENDORLIB_OUTPUT_VARIABLE
    RESULT_VARIABLE
      PERL_VENDORLIB_RESULT_VARIABLE
  )
  IF (NOT PERL_VENDORLIB_RESULT_VARIABLE)
    STRING(REGEX REPLACE "install[a-z]+='([^']+)'.*" "\\1" PERL_VENDORLIB_OUTPUT_VARIABLE ${PERL_VENDORLIB_OUTPUT_VARIABLE})
    SET(PERL_VENDORLIB ${PERL_VENDORLIB_OUTPUT_VARIABLE})
  ENDIF (NOT PERL_VENDORLIB_RESULT_VARIABLE)


  EXECUTE_PROCESS(
    COMMAND
      ${PERL_EXECUTABLE} -V:installarchlib
      OUTPUT_VARIABLE
        PERL_ARCHLIB_OUTPUT_VARIABLE
      RESULT_VARIABLE
        PERL_ARCHLIB_RESULT_VARIABLE
  )
  IF (NOT PERL_ARCHLIB_RESULT_VARIABLE)
    STRING(REGEX REPLACE "install[a-z]+='([^']+)'.*" "\\1" PERL_ARCHLIB_OUTPUT_VARIABLE ${PERL_ARCHLIB_OUTPUT_VARIABLE})
    SET(PERL_ARCHLIB ${PERL_ARCHLIB_OUTPUT_VARIABLE})
  ENDIF (NOT PERL_ARCHLIB_RESULT_VARIABLE)


  EXECUTE_PROCESS(
    COMMAND
      ${PERL_EXECUTABLE} -V:installprivlib
    OUTPUT_VARIABLE
      PERL_PRIVLIB_OUTPUT_VARIABLE
    RESULT_VARIABLE
      PERL_PRIVLIB_RESULT_VARIABLE
  )
  IF (NOT PERL_PRIVLIB_RESULT_VARIABLE)
    STRING(REGEX REPLACE "install[a-z]+='([^']+)'.*" "\\1" PERL_PRIVLIB ${PERL_PRIVLIB_OUTPUT_VARIABLE})
  ENDIF (NOT PERL_PRIVLIB_RESULT_VARIABLE)
ENDIF (PERL_EXECUTABLE)

FIND_LIBRARY(PERL_LIBRARY
  NAMES
    ${PERL_POSSIBLE_LIBRARY_NAME}
    perl5.8.0
  PATHS
    ${PERL_POSSIBLE_LIB_PATHS}
)

MARK_AS_ADVANCED(
  PERL_INCLUDE_PATH
  PERL_EXECUTABLE
  PERL_LIBRARY
  PERL_SITESEARCH
  PERL_SITELIB
  PERL_VENDORARCH
  PERL_VENDORLIB
  PERL_ARCHLIB
  PERL_PRIVLIB
)

