# gozerbot/plugs/admin.py
#
#

""" admin related funtions. """

from gozerbot.commands import cmnds
from gozerbot.persist.persist import Persist
from gozerbot.aliases import aliasreverse
from gozerbot.examples import examples
from gozerbot.plughelp import plughelp

import os

plughelp.add("admin", "admin related functions.")

def handle_cmndtablesave(bot, ievent):
    from gozerbot.datadir import datadir
    cmndtable = Persist(datadir + os.sep + 'run' + os.sep + 'cmndtable')
    if not cmndtable.data:
        cmndtable.data = {}

    for cmndname, c in cmnds.iteritems():
        cmndtable.data[cmndname] = c.plugname
        a = aliasreverse(cmndname)
        if a:
            cmndtable.data[a] = c.plugname

    cmndtable.save()
    ievent.done()

cmnds.add('admin-cmndtable', handle_cmndtablesave, 'OPER')
examples.add("admin-cmndtable", "save the command table", "admin-cmndtable")

def handle_pluginlist(bot, ievent):
    plugins = []
    from gozerbot.datadir import datadir
    pluginlist = Persist(datadir + os.sep + 'run' + os.sep + 'pluginlist')
    if not pluginlist.data:
        pluginlist.data = []
    for cmndname, c in cmnds.iteritems():
        if c.plugname not in plugins:
            plugins.append(c.plugname)
    pluginlist.data = plugins
    pluginlist.save()
    ievent.done()

cmnds.add('admin-pluginlist', handle_pluginlist, 'OPER')
examples.add("admin-pluginlust", "save the plugin list", "admin-pluginlist")
