/* Goxel 3D voxels editor
 *
 * copyright (c) 2018 Guillaume Chereau <guillaume@noctua-software.com>
 *
 * Goxel is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.

 * Goxel is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.

 * You should have received a copy of the GNU General Public License along with
 * goxel.  If not, see <http://www.gnu.org/licenses/>.
 */

/* This file is autogenerated by tools/create_assets.py */

{.path = "data/progs/cherry.goxcf", .size = 469, .data =
    "shape main {\n"
    "    [seed 7]\n"
    "    tree(0, 40, 10)[s 10 light -0.9]\n"
    "}\n"
    "\n"
    "shape tree($n, $e, $f)\n"
    "rule {\n"
    "    cylinder[]\n"
    "    if ($n < $e) {\n"
    "        tree($n + 1)[rz 0+-10 z 0.5 s 0.95 z 0.5 rx 4]\n"
    "    }\n"
    "    if (($n >= $e) || ($n > $f && 0+-1 > 0.5)) {\n"
    "        flower[]\n"
    "    }\n"
    "}\n"
    "rule 0.1 {\n"
    "    tree[rz 180]\n"
    "}\n"
    "rule 0.08 {\n"
    "    tree[]\n"
    "    tree($n + 1)[rz 0+-180 rx -45]\n"
    "}\n"
    "\n"
    "shape flower {\n"
    "     [light 0.5 sat 0.7 sn 1 s 6 z -0.5 x -1 hue -10]\n"
    "     sphere[x 0+-0.5 0+-0.5 light 0+-0.2]\n"
    "}"
},
{.path = "data/progs/city.goxcf", .size = 1199, .data =
    "shape main {\n"
    "    [seed 4]\n"
    "    city[]\n"
    "}\n"
    "\n"
    "shape ground {\n"
    "    [s 128 128 1\n"
    "     light -0.6 sat 0.2 hue 50]\n"
    "    cube[]\n"
    "    loop 16 [] {\n"
    "       cube[x 0+-0.4 0+-0.4 \n"
    "            s 0.2+-0.1 0.2+-0.1 3+-1\n"
    "            light -0.3+-0.2]\n"
    "    }\n"
    "}\n"
    "\n"
    "shape city {\n"
    "    ground[]\n"
    "    loop 128 [wait 1] {\n"
    "        building[x 0+-58 0+-58 s 2+-0.5\n"
    "                 sat 0.2+-0.1 hue 0+-180]\n"
    "    }\n"
    "}\n"
    "\n"
    "shape building\n"
    "// Tall building\n"
    "rule 1 {\n"
    "    [s 3]\n"
    "    $n = int(10+-5)\n"
    "    loop $n [z 1 wait 1] {\n"
    "        $s = 2+-0.2\n"
    "        floor[s $s $s 1 z 0.5]\n"
    "    }\n"
    "    [z $n - 0.5]\n"
    "    loop 1+-2 [] {\n"
    "        antenna[]\n"
    "    }\n"
    "}\n"
    "// Low building\n"
    "rule 1 {\n"
    "   [s 8+-4 8+-4 4+-2 z 0.5]\n"
    "   cube[light -0.3]\n"
    "   windows(8)[]\n"
    "   loop 2+-1 [] {antenna[]}\n"
    "}\n"
    "// Tree\n"
    "rule 10 {\n"
    "   [z 0.5 sn 1 z 0.5]\n"
    "   [sat 1 0.5 light 1 0.2 hue 1 20]\n"
    "   cube[z 0.5 sz 5]\n"
    "   loop 2 [] {\n"
    "       sphere[z 4 s 4+-1\n"
    "              x 0+-0.1 0+-0.1\n"
    "              hue 100+-40]\n"
    "   }\n"
    "}\n"
    "\n"
    "shape windows($n) {\n"
    "    loop $n [rz 90] {\n"
    "       cube[x 0.5 0+-0.4 sn s 1/3 x -0.5\n"
    "            light 1 1 light 0+-0.2]\n"
    "    }\n"
    "}\n"
    "\n"
    "shape floor {\n"
    "    cube[light -0.5+-0.1]\n"
    "    windows(8)[]\n"
    "}\n"
    "\n"
    "shape antenna {\n"
    "    [z 0.5 x 0+-0.4 0+-0.4\n"
    "     sn 1 sz 2+-1 z 0.5\n"
    "     light -0.5]\n"
    "    cube[]\n"
    "}"
},
{.path = "data/progs/intro.goxcf", .size = 2552, .data =
    "// The 'main' shape is always the entry point of the program.\n"
    "shape main {\n"
    "    // Initial random seed of 2.\n"
    "    // Remove this line to use different seed each time.\n"
    "    [seed 2]\n"
    "    // Improves marching cube rendering.\n"
    "    [antialiased 1]\n"
    "\n"
    "    // Render a single white voxel.\n"
    "    cube []\n"
    "\n"
    "    // Put an other cube next to it.\n"
    "    // 'x' applies a translation of 1 along x.\n"
    "    // Those transformation are only applied\n"
    "    // to this cube.\n"
    "    cube [x 1]\n"
    "\n"
    "    // Now render a bigger grey sphere.\n"
    "    // light -0.5 move the light value to half\n"
    "    // the current value of 1 and the target\n"
    "    sphere [s 10 x 1 light -0.5]\n"
    "\n"
    "    // We can also render cylinders:\n"
    "    cylinder [s 10 x -1 light -0.9]\n"
    "\n"
    "    // This time we use a user defined shape.\n"
    "    // And we increase the saturation to give it a color.\n"
    "    my_shape [z 20 light -0.5 sat 0.5]\n"
    "}\n"
    "\n"
    "// A user defined shape\n"
    "shape my_shape {\n"
    "    // s 8 8 1 scales with different values\n"
    "    // for each axis.\n"
    "    // rx A applies a rotation along z of\n"
    "    // 45 deg.\n"
    "\n"
    "    // Note that the color is red, because we set the\n"
    "    // Saturation when we called my_shape.\n"
    "    cube [s 8 8 1  z 1  rz 45]\n"
    "\n"
    "    // Loop 16 time, each time increasing the x\n"
    "    // translation and the hue.\n"
    "    loop 16 [x 2 hue 10] {\n"
    "      cube []\n"
    "    }\n"
    "    // The loop transformations only affect\n"
    "    // the loop block, after it we return to\n"
    "    // the previous context.\n"
    "    sphere [s 6 z 1]\n"
    "\n"
    "    // Let's try a recursive shape:\n"
    "    tree [x -10 s 4]\n"
    "\n"
    "    // And an other one with a bit or randomness:\n"
    "    tree2 [x 10 s 4 rz 180 hue 180]\n"
    "\n"
    "    // A shape with several rules:\n"
    "    my_other_shape [y 10 rz 90 hue -60 s 3]\n"
    "}\n"
    "\n"
    "// Tree render a cylinder and then call itself.\n"
    "// Since we scale down the shape at each iteration\n"
    "// at some point it becomes too small, and is\n"
    "// then automatically stopped.\n"
    "shape tree {\n"
    "    cylinder []\n"
    "    tree [z 1 s 0.99 ry -6]\n"
    "}\n"
    "\n"
    "shape tree2 {\n"
    "    cylinder []\n"
    "    // 'A +- B' means that we use a random value in the range\n"
    "    // A - B, A + B.  this make the second spiral a bit\n"
    "    // messy.\n"
    "    tree2 [z 1 s 0.99 ry -6+-6]\n"
    "}\n"
    "\n"
    "// Here 'my_other_shape' defines several rules.  The rule\n"
    "// used is picked randomly using the weight.\n"
    "shape my_other_shape\n"
    "\n"
    "// Most of the time, just keep growing in z.\n"
    "rule 15 {\n"
    "    cube []\n"
    "    my_other_shape [z 1]\n"
    "}\n"
    "\n"
    "// Sometime split into two\n"
    "rule 1 {\n"
    "    my_other_shape [rx 45 s 0.9]\n"
    "    my_other_shape [rx -45 s 0.9]\n"
    "}\n"
    "\n"
    "// Some other times render a shpere and stop\n"
    "rule 0.5 {\n"
    "    // 'hue 1 70' means that we immediately set the hue\n"
    "    // to 70 (yellow).\n"
    "    sphere [s 3 hue 1 70]\n"
    "}\n"
    ""
},
{.path = "data/progs/planet.goxcf", .size = 523, .data =
    "// Simple planet\n"
    "shape main {\n"
    "    [s 50]\n"
    "    sphere [sat 0.5 light -0.75 hue 200]\n"
    "    loop 3 [] {\n"
    "        continent[rz 0+-180 ry 0+-180\n"
    "                  hue 1 40+-10 sat 1 0.5\n"
    "                  light -0.5+-0.1]\n"
    "    }\n"
    "    loop 16 [wait 1] {\n"
    "        cloud [rz 0+-180 ry 0+-180\n"
    "               hue 200 light -0.1 sat 0.5]\n"
    "    }\n"
    "}\n"
    "\n"
    "shape continent {\n"
    "    loop 30 [rz 10 rx 0+-80 wait 1] {\n"
    "        sphere[x 0.3 s 0.4+-0.05]\n"
    "    }\n"
    "}\n"
    "\n"
    "shape cloud {\n"
    "    loop 5 [rz 2 rx 0+-180 wait 1] {\n"
    "       sphere[x 0.5 s 0.04 +- 0.01]\n"
    "    }\n"
    "}\n"
    ""
},
{.path = "data/progs/test.goxcf", .size = 323, .data =
    "// Simple Test\n"
    "\n"
    "shape branch\n"
    "rule {\n"
    "    cylinder [sz 0.7]\n"
    "    branch [rz 0 z 0.25 s 0.9 rx 30 z 0.25\n"
    "            light -0.1 hue 10 sat 0.1]\n"
    "}\n"
    "rule 0.2 {\n"
    "branch [rz 180]\n"
    "}\n"
    "rule 0.2 {\n"
    "    branch [rz 90]\n"
    "}\n"
    "rule 0.1 {\n"
    "    branch [rx -90 s 0.8 z 1]\n"
    "    branch []\n"
    "}\n"
    "\n"
    "shape main {\n"
    "    [light 1 antialiased 1]\n"
    "    branch [s 32]\n"
    "}\n"
    ""
},
{.path = "data/progs/test2.goxcf", .size = 419, .data =
    "shape main {\n"
    "    [antialiased 1]\n"
    "    [light 0.5 sat 0.5 s 100]\n"
    "    loop 5 [s -0.95 light 0.1 sat 0.01 hue 5] {\n"
    "       sphere [light -0.6 hue 30]\n"
    "    }\n"
    "    loop 30 [wait 1] {\n"
    "        sphere [sub rz 0+-180 ry 0+-180\n"
    "                z 0.5 s 0.3]\n"
    "    }\n"
    "    loop 2 [rz 90] {\n"
    "        loop 120 [ry 10 wait 1] {\n"
    "            sphere [hue 30+-30 light -0.5+-0.4\n"
    "                    z 0.5 s 0.05+-0.01 z 4+-0.5]\n"
    "        }\n"
    "    }\n"
    "}\n"
    ""
},
{.path = "data/progs/test3.goxcf", .size = 302, .data =
    "shape main {\n"
    "   [antialiased 1]\n"
    "   loop 8 [rz 45] {\n"
    "       test [s 20 x 2]\n"
    "   }\n"
    "}\n"
    "\n"
    "shape test {\n"
    "    [sat 0.4 light -0.2 hue 240]\n"
    "    sphere[]\n"
    "    cube [z 0.5 sub]\n"
    "    tige (15) [s 0.5 light -0.5]\n"
    "}\n"
    "\n"
    "shape tige ($n) {\n"
    "    cylinder[]\n"
    "    if $n {\n"
    "        tige($n - 1)[z 0.5 ry $n z 0.5 sat -0.1]\n"
    "    }\n"
    "}\n"
    ""
},
{.path = "data/progs/tree-big.goxcf", .size = 541, .data =
    "\n"
    "shape leaf {\n"
    "    cube[]\n"
    "    leaf[x 0.5 s 0.9 0.9 0.8 ry 25 x 0.4]\n"
    "}\n"
    "\n"
    "shape top {\n"
    "    loop 8 [rz 360 / 8] {\n"
    "        [life 8 sy 2 z 0+-5]\n"
    "        leaf[s 5 light -0.4 sat 0.5 hue 60+-20 ry -45]\n"
    "    }\n"
    "}\n"
    "\n"
    "shape part($n) {\n"
    "    loop $i = $n [z 1 rz 30+-10 rx 0+-10 wait 1] {\n"
    "        cylinder[s 4 x 0.1 light 0+-0.1]\n"
    "        if ($i == int($n - 2)) {\n"
    "            top[]\n"
    "        }\n"
    "    }\n"
    "}\n"
    "\n"
    "shape main {\n"
    "    [antialiased 1 hue 40 light -0.5 sat 0.5]\n"
    "    $n = 40+-10\n"
    "    loop 3 [rz 120+-45] {\n"
    "        [y 0.5]\n"
    "        part($n)[light -0.3+-0.05]\n"
    "    }\n"
    "}\n"
    ""
},
{.path = "data/progs/tree-small.goxcf", .size = 372, .data =
    "shape branch2 {\n"
    "    cube[]\n"
    "    branch2 [z 0.5 s 0.8 rx 20+-4 z 0.5]\n"
    "}\n"
    "\n"
    "shape branch {\n"
    "   [rx 90]\n"
    "   branch2[s 2]\n"
    "}\n"
    "\n"
    "shape tree($s) {\n"
    "    loop $s [z 1] {\n"
    "       cube[s 1 light -0.8+-0.1 sat 0.5]\n"
    "    }\n"
    "    [z $s]\n"
    "    [sat 1 light -0.5 hue 50+-30]\n"
    "    loop 6 [rz 360 / 6 rz 0+-10] {\n"
    "         branch[light 0+-0.3]\n"
    "    }\n"
    "}\n"
    "\n"
    "shape main {\n"
    "    [antialiased 0]\n"
    "    tree(8+-2)[]\n"
    "}\n"
    ""
},



