/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef _GNOME_SCAN_MODULE_MANAGER_H_
#define _GNOME_SCAN_MODULE_MANAGER_H_

#include <glib-object.h>

G_BEGIN_DECLS

#define GNOME_TYPE_SCAN_MODULE_MANAGER             (gnome_scan_module_manager_get_type ())
#define GNOME_SCAN_MODULE_MANAGER(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_MODULE_MANAGER, GnomeScanModuleManager))
#define GNOME_SCAN_MODULE_MANAGER_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_MODULE_MANAGER, GnomeScanModuleManagerClass))
#define GNOME_IS_SCAN_MODULE_MANAGER(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_MODULE_MANAGER))
#define GNOME_IS_SCAN_MODULE_MANAGER_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_MODULE_MANAGER))
#define GNOME_SCAN_MODULE_MANAGER_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_MODULE_MANAGER, GnomeScanModuleManagerClass))

typedef struct _GnomeScanModuleManagerClass GnomeScanModuleManagerClass;
typedef struct _GnomeScanModuleManager GnomeScanModuleManager;

struct _GnomeScanModuleManagerClass
{
	GObjectClass parent_class;
};

/**
 * GnomeScanModuleManager:
 *
 * The #GnomeScanModuleManager object find and load all installed
 * #GnomeScanModule.
 **/
struct _GnomeScanModuleManager
{
	/*< private >*/
	GObject parent_instance;
	
	gchar	*path;
	GSList	*modules;
};

GType	gnome_scan_module_manager_get_type (void) G_GNUC_CONST;
GnomeScanModuleManager*
		gnome_scan_module_manager_new (gchar *path);
void	gnome_scan_module_manager_query_modules (GnomeScanModuleManager *manager);
void	gnome_scan_module_manager_unload_modules (GnomeScanModuleManager *manager);
G_END_DECLS

#endif /* _GNOME_SCAN_MODULE_MANAGER_H_ */
