------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-parameters.ads,v 1.12 2007/04/25 10:08:46 vagul Exp $

with OCI.Thick.Statements;

package OCI.Thick.Parameters is

   use Statements;

   type SQL_Type is
     (CHR,    -- (ORANET TYPE) character string
      NUM,    -- (ORANET TYPE) oracle numeric
      INT,    -- (ORANET TYPE) integer
      FLT,    -- (ORANET TYPE) Floating point number
      STR,    -- zero terminated string
      VNU,    -- NUM with preceding length byte
      PDN,    -- (ORANET TYPE) Packed Decimal Numeric
      LNG,    -- long
      VCS,    -- Variable character string
      NON,    -- Null/empty PCC Descriptor entry
      RID,    -- rowid
      DAT,    -- date in oracle format
      VBI,    -- binary in VCS format
      BIN,    -- binary data(DTYBIN)
      LBI,    -- long binary
      UIN,    -- unsigned integer
      SLS,    -- Display sign leading separate
      LVC,    -- Longer longs (char)
      LVB,    -- Longer long binary
      AFC,    -- Ansi fixed char
      AVC,    -- Ansi Var char
      CUR,    -- cursor  type
      RDD,    -- rowid descriptor
      LAB,    -- label type
      OSL,    -- oslabel type
      NTY,    -- named object type
      REF,    -- ref type
      CLOB,   -- character lob
      BLOB,   -- binary lob
      BFILE,  -- binary file lob
      CFILE,  -- character file lob
      RSET,   -- result set type
      NCO,    -- named collection type (varray or nested table)
      VST,    -- OCIString type
      ODT,    -- OCIDate type
      DATE,          -- ANSI Date
      TIME,          -- TIME
      TIME_TZ,       -- TIME WITH TIME ZONE
      TIMESTAMP,     -- TIMESTAMP
      TIMESTAMP_TZ,  -- TIMESTAMP WITH TIME ZONE
      INTERVAL_YM,   -- INTERVAL YEAR TO MONTH
      INTERVAL_DS,   -- INTERVAL DAY TO SECOND
      TIMESTAMP_LTZ, -- TIMESTAMP WITH LOCAL TZ
      PNTY);         -- pl/sql representation of named

   --  More readable constants for some SQL_Type's.

   SQL_Date            : constant SQL_Type;
   SQL_Float           : constant SQL_Type;
   SQL_Number          : constant SQL_Type;
   SQL_Decimal         : constant SQL_Type;
   SQL_Unsigned8       : constant SQL_Type;
   SQL_Integer         : constant SQL_Type;
   SQL_Raw             : constant SQL_Type;
   SQL_Varchar2        : constant SQL_Type;
   SQL_Char            : constant SQL_Type;
   SQL_Varchar         : constant SQL_Type;
   SQL_Mlslabel        : constant SQL_Type;
   SQL_Object          : constant SQL_Type;
   SQL_NamedCollection : constant SQL_Type;
   SQL_Long            : constant SQL_Type;

   type Parameter is new Handle_Reference with private;

   type Parameter_Array is array (Positive range <>) of Parameter;

   function Column (Stmt : Statement; Position : Positive) return Parameter;
   function Get_Parameters (Stmt : Statement) return Parameter_Array;

   function Schema_Name  (Param : Parameter) return String;
   function Name         (Param : Parameter) return String;
   function Type_Name    (Param : Parameter) return String;
   function Data_Type    (Param : Parameter) return SQL_Type;
   function Data_Size    (Param : Parameter) return Natural;
   function Precision    (Param : Parameter) return Integer;
   function Scale        (Param : Parameter) return Integer;
   function Is_Null      (Param : Parameter) return Boolean;

   function Get_SQL_Type (Param : Parameter) return SQL_Type renames Data_Type;
   --  Get_SQL_Type is obsolete not good name for backward compartibility

private

   for SQL_Type'Size use Ub2'Size;

   for SQL_Type use
     (CHR           => SQLT_CHR,
      NUM           => SQLT_NUM,
      INT           => SQLT_INT,
      FLT           => SQLT_FLT,
      STR           => SQLT_STR,
      VNU           => SQLT_VNU,
      PDN           => SQLT_PDN,
      LNG           => SQLT_LNG,
      VCS           => SQLT_VCS,
      NON           => SQLT_NON,
      RID           => SQLT_RID,
      DAT           => SQLT_DAT,
      VBI           => SQLT_VBI,
      BIN           => SQLT_BIN,
      LBI           => SQLT_LBI,
      UIN           => SQLT_UIN,
      SLS           => SQLT_SLS,
      LVC           => SQLT_LVC,
      LVB           => SQLT_LVB,
      AFC           => SQLT_AFC,
      AVC           => SQLT_AVC,
      CUR           => SQLT_CUR,
      RDD           => SQLT_RDD,
      LAB           => SQLT_LAB,
      OSL           => SQLT_OSL,
      NTY           => SQLT_NTY,
      REF           => SQLT_REF,
      CLOB          => SQLT_CLOB,
      BLOB          => SQLT_BLOB,
      BFILE         => SQLT_BFILE,
      CFILE         => SQLT_CFILE,
      RSET          => SQLT_RSET,
      NCO           => SQLT_NCO,
      VST           => SQLT_VST,
      ODT           => SQLT_ODT,
      DATE          => SQLT_DATE,
      TIME          => SQLT_TIME,
      TIME_TZ       => SQLT_TIME_TZ,
      TIMESTAMP     => SQLT_TIMESTAMP,
      TIMESTAMP_TZ  => SQLT_TIMESTAMP_TZ,
      INTERVAL_YM   => SQLT_INTERVAL_YM,
      INTERVAL_DS   => SQLT_INTERVAL_DS,
      TIMESTAMP_LTZ => SQLT_TIMESTAMP_LTZ,
      PNTY          => SQLT_PNTY);

   SQL_Date            : constant SQL_Type := DAT;
   SQL_Float           : constant SQL_Type := FLT;
   SQL_Number          : constant SQL_Type := NUM;
   SQL_Decimal         : constant SQL_Type := PDN;
   SQL_Unsigned8       : constant SQL_Type := BIN;
   SQL_Integer         : constant SQL_Type := INT;
   SQL_Raw             : constant SQL_Type := LVB;
   SQL_Varchar2        : constant SQL_Type := VCS;
   SQL_Char            : constant SQL_Type := AFC;
   SQL_Varchar         : constant SQL_Type := CHR;
   SQL_Mlslabel        : constant SQL_Type := LAB;
   SQL_Object          : constant SQL_Type := NTY;
   SQL_NamedCollection : constant SQL_Type := NCO;
   SQL_Long            : constant SQL_Type := LNG;

   type Parameter is new Handle_Reference with record
      Last_Stmt : Statement;
   end record;

   procedure Destroy (Object : in out Parameter);

end OCI.Thick.Parameters;
