// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#ifndef USE_X

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#include "defines.h"
#include "structs.h"
#include "globals.h"
#include "protos.h"

#include "Sequencer.h"

void
NoXProcessEvent ()
{
  fd_set readFds, writeFds;
  static int songFinished = 0;
  static int writeEnabled = 1;
  extern Sequencer *seq;
  SEQ_DECLAREBUF();

  FD_ZERO (&readFds);
  FD_ZERO (&writeFds);
  FD_SET (0, &readFds);	/* standard input */
  FD_SET (seq->seqFd(), &readFds);

  if (writeEnabled)
    FD_SET (seq->seqFd(), &writeFds);

  select (seq->seqFd() + 1, &readFds, &writeFds, NULL, NULL);
  
  if (FD_ISSET (seq->seqFd(), &writeFds))
    {
      if (stopFlag)
	songFinished = 1;

      do
	{
	  while ((seq->bufferSize() < 1) && (!songFinished))
	    if ((songFinished = playNextPosition()))
	      {
		syncTime();
		SEQ_ECHO_BACK(ECHO_END);
		seq->dump();
	      }
	}
      while ((seq->bufferSize() > 0) && (seq->write() != -1));

      if ((seq->bufferSize() == 0) && (songFinished))
	writeEnabled = 0;
   }
  
  if (FD_ISSET (seq->seqFd(), &readFds))
    {
      seqInput = procInput ();
      
      if (seqInput == ECHO_END)
	{
	  songFinished = 0;
	  writeEnabled = 1;
	}
    }

  if (FD_ISSET (0, &readFds))
    timerHandler (-1);
}
#endif
