import gobject
import gst
import gtk

from glitch.camera import Camera
from glitch.gst.camerasrc import CameraSource
from glitch.limbo.objects import make_lit_test_scene

if __name__ == '__main__':
    gobject.threads_init()
    gtk.gdk.threads_init()

    camera = Camera(eye=[0, 2, 3], children=[make_lit_test_scene()])
    src = CameraSource(camera)
    sink = gst.parse_bin_from_description(
        'ffmpegcolorspace ! autovideosink', True)

    pipeline = gst.Pipeline()
    pipeline.add(src, sink)
    gst.element_link_many(src, sink)
    pipeline.set_state(gst.STATE_PLAYING)

    loop = gobject.MainLoop()

    try:
        loop.run()
    except KeyboardInterrupt:
        pass

    pipeline.set_state(gst.STATE_NULL)

