/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/**
 *	This generated bean class HttpAccessLog matches the DTD element http-access-log
 *
 */

package com.sun.enterprise.config.serverbeans;

import org.w3c.dom.*;
import org.netbeans.modules.schema2beans.*;
import java.beans.*;
import java.util.*;
import java.io.Serializable;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.util.i18n.StringManager;

// BEGIN_NOI18N

public class HttpAccessLog extends ConfigBean implements Serializable
{

	static Vector comparators = new Vector();
	private static final org.netbeans.modules.schema2beans.Version runtimeVersion = new org.netbeans.modules.schema2beans.Version(4, 2, 0);


	public HttpAccessLog() {
		this(Common.USE_DEFAULT_VALUES);
	}

	public HttpAccessLog(int options)
	{
		super(comparators, runtimeVersion);
		// Properties (see root bean comments for the bean graph)
		initPropertyTables(0);
		this.initialize(options);
	}

	// Setting the default values of the properties
	void initialize(int options) {

	}

	/**
	* Getter for LogDirectory of the Element http-access-log
	* @return  the LogDirectory of the Element http-access-log
	*/
	public String getLogDirectory() {
		return getAttributeValue(ServerTags.LOG_DIRECTORY);
	}
	/**
	* Modify  the LogDirectory of the Element http-access-log
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setLogDirectory(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.LOG_DIRECTORY, v, overwrite);
	}
	/**
	* Modify  the LogDirectory of the Element http-access-log
	* @param v the new value
	*/
	public void setLogDirectory(String v) {
		setAttributeValue(ServerTags.LOG_DIRECTORY, v);
	}
	/**
	* Get the default value of LogDirectory from dtd
	*/
	public static String getDefaultLogDirectory() {
		return "${com.sun.aas.instanceRoot}/logs/access".trim();
	}
	/**
	* Getter for Iponly of the Element http-access-log
	* @return  the Iponly of the Element http-access-log
	*/
	public boolean isIponly() {
		return toBoolean(getAttributeValue(ServerTags.IPONLY));
	}
	/**
	* Modify  the Iponly of the Element http-access-log
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setIponly(boolean v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.IPONLY, ""+(v==true), overwrite);
	}
	/**
	* Modify  the Iponly of the Element http-access-log
	* @param v the new value
	*/
	public void setIponly(boolean v) {
		setAttributeValue(ServerTags.IPONLY, ""+(v==true));
	}
	/**
	* Get the default value of Iponly from dtd
	*/
	public static String getDefaultIponly() {
		return "true".trim();
	}
	/**
	* get the xpath representation for this element
	* returns something like abc[@name='value'] or abc
	* depending on the type of the bean
	*/
	protected String getRelativeXPath() {
	    String ret = null;
	    ret = "http-access-log";
	    return (null != ret ? ret.trim() : null);
	}

	/*
	* generic method to get default value from dtd
	*/
	public static String getDefaultAttributeValue(String attr) {
		if(attr == null) return null;
		attr = attr.trim();
		if(attr.equals(ServerTags.LOG_DIRECTORY)) return "${com.sun.aas.instanceRoot}/logs/access".trim();
		if(attr.equals(ServerTags.IPONLY)) return "true".trim();
	return null;
	}
	//
	public static void addComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.add(c);
	}

	//
	public static void removeComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.remove(c);
	}
	public void validate() throws org.netbeans.modules.schema2beans.ValidateException {
	}

	// Dump the content of this bean returning it as a String
	public void dump(StringBuffer str, String indent){
		String s;
		Object o;
		org.netbeans.modules.schema2beans.BaseBean n;
	}
	public String dumpBeanNode(){
		StringBuffer str = new StringBuffer();
		str.append("HttpAccessLog\n");	// NOI18N
		this.dump(str, "\n  ");	// NOI18N
		return str.toString();
	}}

// END_NOI18N

