package actions

import (
	"github.com/MakeNowJust/heredoc"
	"github.com/cli/cli/v2/pkg/cmdutil"
	"github.com/cli/cli/v2/pkg/iostreams"
	"github.com/spf13/cobra"
)

func NewCmdActions(f *cmdutil.Factory) *cobra.Command {
	cs := f.IOStreams.ColorScheme()

	cmd := &cobra.Command{
		Use:    "actions",
		Short:  "Learn about working with GitHub Actions",
		Long:   actionsExplainer(cs),
		Hidden: true,
	}

	cmdutil.DisableAuthCheck(cmd)

	return cmd
}

func actionsExplainer(cs *iostreams.ColorScheme) string {
	header := cs.Bold("Welcome to GitHub Actions on the command line.")
	runHeader := cs.Bold("Interacting with workflow runs")
	workflowHeader := cs.Bold("Interacting with workflow files")
	cacheHeader := cs.Bold("Interacting with the GitHub Actions cache")

	return heredoc.Docf(`
			%[2]s

			GitHub CLI integrates with GitHub Actions to help you manage runs and workflows.

			%[3]s
			gh run list:      List recent workflow runs  
			gh run view:      View details for a workflow run or one of its jobs  
			gh run watch:     Watch a workflow run while it executes  
			gh run rerun:     Rerun a failed workflow run  
			gh run download:  Download artifacts generated by runs

			To see more help, run %[1]sgh help run <subcommand>%[1]s

			%[4]s
			gh workflow list:     List workflow files in your repository
			gh workflow view:     View details for a workflow file  
			gh workflow enable:   Enable a workflow file  
			gh workflow disable:  Disable a workflow file  
			gh workflow run:      Trigger a workflow_dispatch run for a workflow file

			To see more help, run %[1]sgh help workflow <subcommand>%[1]s

			%[5]s
			gh cache list:    List all the caches saved in GitHub Actions for a repository
			gh cache delete:  Delete one or all saved caches in GitHub Actions for a repository

			To see more help, run %[1]sgh help cache <subcommand>%[1]s

		`, "`", header, runHeader, workflowHeader, cacheHeader)
}
