// CLASSIFICATION: UNCLASSIFIED

/*
 * CreateEllipsoidDlg.java
 * Created on September 5, 2000, 11:26 AM
 */

package geotrans3.gui;


import geotrans3.exception.CoordinateConversionException;
import geotrans3.jni.JNICoordinateConversionService;
import geotrans3.jni.JNIEllipsoidLibrary;
import geotrans3.misc.StringHandler;
import geotrans3.utility.Utility;
import geotrans3.utility.Platform;


/**
 * This class create a user defined Ellipsoid  
 * if the input parameters are valid.  
 * 
 *
 * @author  Carol Finn
 * @version 1.0,  September 2000
 * 
 */
public class CreateEllipsoidDlg extends javax.swing.JDialog
{
  private JNIEllipsoidLibrary jniEllipsoidLibrary;
  
  /** Creates new form CreateEllip */
  public CreateEllipsoidDlg(JNICoordinateConversionService _jniCoordinateConversionService, java.awt.Frame parent, boolean modal) throws CoordinateConversionException
  {
    super(parent, modal);

    jniEllipsoidLibrary = new JNIEllipsoidLibrary(_jniCoordinateConversionService.getEllipsoidLibrary());

    initComponents();
    pack();
    Utility.center(parent, this);
    if(Platform.isJavaV1_3)
    {
      ellipsoidCodeLabel.setForeground(java.awt.Color.black);
      ellipsoidNameLabel.setForeground(java.awt.Color.black);
      semiMajorAxisLabel.setForeground(java.awt.Color.black);
      invFlatteningLabel.setForeground(java.awt.Color.black);
    }

    if(Platform.isUnix)
    {
      ellipsoidCodeLabel.setFont(new java.awt.Font("Dialog", 1, 10));
      ellipsoidNameLabel.setFont(new java.awt.Font("Dialog", 1, 10));
      semiMajorAxisLabel.setFont(new java.awt.Font("Dialog", 1, 10));
      invFlatteningLabel.setFont(new java.awt.Font("Dialog", 1, 10));
      okButton.setFont(new java.awt.Font("Dialog", 1, 10));
      cancelButton.setFont(new java.awt.Font("Dialog", 1, 10));
    }
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents() {//GEN-BEGIN:initComponents
      createEllipsoidPanel = new javax.swing.JPanel();
      ellipsoidCodeLabel = new javax.swing.JLabel();
      ellipsoidNameLabel = new javax.swing.JLabel();
      semiMajorAxisLabel = new javax.swing.JLabel();
      invFlatteningLabel = new javax.swing.JLabel();
      ellipsoidCodeTextField = new javax.swing.JTextField();
      ellipsoidNameTextField = new javax.swing.JTextField();
      semiMajorAxisTextField = new javax.swing.JTextField();
      invFlatteningTextField = new javax.swing.JTextField();
      buttonsPanel = new javax.swing.JPanel();
      okButton = new javax.swing.JButton();
      cancelButton = new javax.swing.JButton();
      
      getContentPane().setLayout(new java.awt.GridBagLayout());
      java.awt.GridBagConstraints gridBagConstraints2;
      
      setTitle("Create Ellipsoid ");
      setResizable(false);
      addWindowListener(new java.awt.event.WindowAdapter() {
          public void windowClosing(java.awt.event.WindowEvent evt) {
              closeDialog(evt);
          }
      });
      
      createEllipsoidPanel.setLayout(new java.awt.GridBagLayout());
      java.awt.GridBagConstraints gridBagConstraints4;
      
      createEllipsoidPanel.setMinimumSize(new java.awt.Dimension(282, 114));
      createEllipsoidPanel.setPreferredSize(new java.awt.Dimension(282, 114));
      ellipsoidCodeLabel.setText("Code:");
      ellipsoidCodeLabel.setMaximumSize(new java.awt.Dimension(120, 16));
      ellipsoidCodeLabel.setMinimumSize(new java.awt.Dimension(120, 16));
      ellipsoidCodeLabel.setPreferredSize(new java.awt.Dimension(120, 16));
      gridBagConstraints4 = new java.awt.GridBagConstraints();
      gridBagConstraints4.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints4.insets = new java.awt.Insets(0, 0, 0, 6);
      createEllipsoidPanel.add(ellipsoidCodeLabel, gridBagConstraints4);
      
      ellipsoidNameLabel.setText("Name:");
      ellipsoidNameLabel.setMaximumSize(new java.awt.Dimension(120, 16));
      ellipsoidNameLabel.setMinimumSize(new java.awt.Dimension(120, 16));
      ellipsoidNameLabel.setPreferredSize(new java.awt.Dimension(120, 16));
      gridBagConstraints4 = new java.awt.GridBagConstraints();
      gridBagConstraints4.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints4.insets = new java.awt.Insets(0, 6, 0, 0);
      createEllipsoidPanel.add(ellipsoidNameLabel, gridBagConstraints4);
      
      semiMajorAxisLabel.setText("Semi-Major Axis (m):");
      semiMajorAxisLabel.setMaximumSize(new java.awt.Dimension(120, 16));
      semiMajorAxisLabel.setMinimumSize(new java.awt.Dimension(120, 16));
      semiMajorAxisLabel.setPreferredSize(new java.awt.Dimension(120, 16));
      gridBagConstraints4 = new java.awt.GridBagConstraints();
      gridBagConstraints4.gridx = 0;
      gridBagConstraints4.gridy = 2;
      gridBagConstraints4.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints4.insets = new java.awt.Insets(12, 0, 0, 6);
      createEllipsoidPanel.add(semiMajorAxisLabel, gridBagConstraints4);
      
      invFlatteningLabel.setText("Inverse Flattening:");
      invFlatteningLabel.setMaximumSize(new java.awt.Dimension(120, 16));
      invFlatteningLabel.setMinimumSize(new java.awt.Dimension(120, 16));
      invFlatteningLabel.setPreferredSize(new java.awt.Dimension(120, 16));
      gridBagConstraints4 = new java.awt.GridBagConstraints();
      gridBagConstraints4.gridx = 1;
      gridBagConstraints4.gridy = 2;
      gridBagConstraints4.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints4.insets = new java.awt.Insets(12, 6, 0, 0);
      createEllipsoidPanel.add(invFlatteningLabel, gridBagConstraints4);
      
      ellipsoidCodeTextField.setText("WE");
      ellipsoidCodeTextField.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
      ellipsoidCodeTextField.setMinimumSize(new java.awt.Dimension(120, 20));
      ellipsoidCodeTextField.setPreferredSize(new java.awt.Dimension(120, 20));
      gridBagConstraints4 = new java.awt.GridBagConstraints();
      gridBagConstraints4.gridx = 0;
      gridBagConstraints4.gridy = 1;
      gridBagConstraints4.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints4.insets = new java.awt.Insets(0, 0, 0, 6);
      createEllipsoidPanel.add(ellipsoidCodeTextField, gridBagConstraints4);
      
      ellipsoidNameTextField.setText("WGS84");
      ellipsoidNameTextField.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
      ellipsoidNameTextField.setMinimumSize(new java.awt.Dimension(120, 20));
      ellipsoidNameTextField.setPreferredSize(new java.awt.Dimension(120, 20));
      gridBagConstraints4 = new java.awt.GridBagConstraints();
      gridBagConstraints4.gridx = 1;
      gridBagConstraints4.gridy = 1;
      gridBagConstraints4.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints4.insets = new java.awt.Insets(0, 6, 0, 0);
      createEllipsoidPanel.add(ellipsoidNameTextField, gridBagConstraints4);
      
      semiMajorAxisTextField.setText("6378137");
      semiMajorAxisTextField.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
      semiMajorAxisTextField.setMinimumSize(new java.awt.Dimension(120, 20));
      semiMajorAxisTextField.setPreferredSize(new java.awt.Dimension(120, 20));
      gridBagConstraints4 = new java.awt.GridBagConstraints();
      gridBagConstraints4.gridx = 0;
      gridBagConstraints4.gridy = 3;
      gridBagConstraints4.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints4.insets = new java.awt.Insets(0, 0, 0, 6);
      createEllipsoidPanel.add(semiMajorAxisTextField, gridBagConstraints4);
      
      invFlatteningTextField.setText("300");
      invFlatteningTextField.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
      invFlatteningTextField.setMinimumSize(new java.awt.Dimension(120, 20));
      invFlatteningTextField.setPreferredSize(new java.awt.Dimension(120, 20));
      gridBagConstraints4 = new java.awt.GridBagConstraints();
      gridBagConstraints4.gridx = 1;
      gridBagConstraints4.gridy = 3;
      gridBagConstraints4.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints4.insets = new java.awt.Insets(0, 6, 0, 0);
      createEllipsoidPanel.add(invFlatteningTextField, gridBagConstraints4);
      
      gridBagConstraints2 = new java.awt.GridBagConstraints();
      getContentPane().add(createEllipsoidPanel, gridBagConstraints2);
      
      buttonsPanel.setLayout(new java.awt.GridBagLayout());
      java.awt.GridBagConstraints gridBagConstraints3;
      
      okButton.setMnemonic(java.awt.event.KeyEvent.VK_O);
      okButton.setText("OK");
      okButton.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
      okButton.setMaximumSize(new java.awt.Dimension(43, 22));
      okButton.setMinimumSize(new java.awt.Dimension(43, 22));
      okButton.setPreferredSize(new java.awt.Dimension(43, 22));
      okButton.addActionListener(new java.awt.event.ActionListener() {
          public void actionPerformed(java.awt.event.ActionEvent evt) {
              okActionPerformed(evt);
          }
      });
      
      gridBagConstraints3 = new java.awt.GridBagConstraints();
      gridBagConstraints3.gridx = 0;
      gridBagConstraints3.gridy = 2;
      gridBagConstraints3.ipadx = 25;
      gridBagConstraints3.insets = new java.awt.Insets(0, 0, 0, 10);
      buttonsPanel.add(okButton, gridBagConstraints3);
      
      cancelButton.setMnemonic(java.awt.event.KeyEvent.VK_C);
      cancelButton.setText("Cancel");
      cancelButton.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
      cancelButton.setMaximumSize(new java.awt.Dimension(43, 22));
      cancelButton.setMinimumSize(new java.awt.Dimension(43, 22));
      cancelButton.setPreferredSize(new java.awt.Dimension(43, 22));
      cancelButton.addActionListener(new java.awt.event.ActionListener() {
          public void actionPerformed(java.awt.event.ActionEvent evt) {
              cancelActionPerformed(evt);
          }
      });
      
      gridBagConstraints3 = new java.awt.GridBagConstraints();
      gridBagConstraints3.gridx = 2;
      gridBagConstraints3.gridy = 2;
      gridBagConstraints3.ipadx = 25;
      gridBagConstraints3.insets = new java.awt.Insets(0, 10, 0, 0);
      buttonsPanel.add(cancelButton, gridBagConstraints3);
      
      gridBagConstraints2 = new java.awt.GridBagConstraints();
      gridBagConstraints2.gridx = 0;
      gridBagConstraints2.gridy = 2;
      gridBagConstraints2.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints2.insets = new java.awt.Insets(5, 0, 8, 0);
      getContentPane().add(buttonsPanel, gridBagConstraints2);
      
  }//GEN-END:initComponents

  private void cancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelActionPerformed
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_cancelActionPerformed

  private void okActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okActionPerformed
    StringHandler stringHandler = new StringHandler();
    
    double semiMajorAxis = stringHandler.stringToDouble(semiMajorAxisTextField.getText().trim(), "Invalid Semi-Major Axis");
    double invFlattening = 1.0 / (stringHandler.stringToDouble(invFlatteningTextField.getText().trim(), "Invalid Inverse Flattening"));
    
    if(stringHandler.getError())
    {
        stringHandler.displayErrorMsg(this);
    }
    else
    {
        try
        {
            jniEllipsoidLibrary.defineEllipsoid(ellipsoidCodeTextField.getText().trim(),
                                               ellipsoidNameTextField.getText().trim(),
                                               semiMajorAxis, invFlattening);
            setVisible (false);
            dispose ();
        }     
        catch(CoordinateConversionException e)
        {
            stringHandler.displayErrorMsg(this, e.getMessage());
        }
    }   
  }//GEN-LAST:event_okActionPerformed

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog

  /**
  * @param args the command line arguments
  */
  public static void main (String args[]) {
  /*  try
    {
      new CreateEllipsoidDlg (new JNICoordinateConversionService(), new javax.swing.JFrame (), true).show ();
    }
    catch(Exception e)
    {
      System.out.println(e.getMessage());
    }*/
  }
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel createEllipsoidPanel;
  private javax.swing.JLabel ellipsoidCodeLabel;
  private javax.swing.JLabel ellipsoidNameLabel;
  private javax.swing.JLabel semiMajorAxisLabel;
  private javax.swing.JLabel invFlatteningLabel;
  private javax.swing.JTextField ellipsoidCodeTextField;
  private javax.swing.JTextField ellipsoidNameTextField;
  private javax.swing.JTextField semiMajorAxisTextField;
  private javax.swing.JTextField invFlatteningTextField;
  private javax.swing.JPanel buttonsPanel;
  private javax.swing.JButton okButton;
  private javax.swing.JButton cancelButton;
  // End of variables declaration//GEN-END:variables

}  // end of class.

// CLASSIFICATION: UNCLASSIFIED
