#ifndef GENSIO_CONTROL_H
#define GENSIO_CONTROL_H

#define GENSIO_CONTROL_DEPTH_ALL	-1
#define GENSIO_CONTROL_DEPTH_FIRST	-2

#define GENSIO_CONTROL_GET	true
#define GENSIO_CONTROL_SET	false

#define GENSIO_CONTROL_NODELAY			1u
#define GENSIO_CONTROL_STREAMS			2u
#define GENSIO_CONTROL_SEND_BREAK		3u
#define GENSIO_CONTROL_GET_PEER_CERT_NAME	4u
#define GENSIO_CONTROL_CERT_AUTH		5u
#define GENSIO_CONTROL_USERNAME			6u
#define GENSIO_CONTROL_SERVICE			7u
#define GENSIO_CONTROL_CERT			8u
#define GENSIO_CONTROL_CERT_FINGERPRINT		9u
#define GENSIO_CONTROL_ENVIRONMENT		10u
#define GENSIO_CONTROL_MAX_WRITE_PACKET		11u
#define GENSIO_CONTROL_ARGS			12u
#define GENSIO_CONTROL_EXIT_CODE		13u
#define GENSIO_CONTROL_WAIT_TASK		14u
#define GENSIO_CONTROL_ADD_MCAST		15u
#define GENSIO_CONTROL_DEL_MCAST		16u
#define GENSIO_CONTROL_LADDR			17u
#define GENSIO_CONTROL_LPORT			18u
#define GENSIO_CONTROL_CLOSE_OUTPUT		19u
#define GENSIO_CONTROL_CONNECT_ADDR_STR		20u
#define GENSIO_CONTROL_RADDR			21u
#define GENSIO_CONTROL_RADDR_BIN		22u
#define GENSIO_CONTROL_REMOTE_ID		23u
#define GENSIO_CONTROL_KILL_TASK		24u
#define GENSIO_CONTROL_MCAST_LOOP		25u
#define GENSIO_CONTROL_MCAST_TTL		26u
#define GENSIO_CONTROL_PASSWORD			27u
#define GENSIO_CONTROL_2FA			28u
#define GENSIO_CONTROL_AUX_DATA			29u
#define GENSIO_CONTROL_REM_AUX_DATA		30u
#define GENSIO_CONTROL_IOD			31u
#define GENSIO_CONTROL_EXTRAINFO		32u
#define GENSIO_CONTROL_ENABLE_OOB		33u
#define GENSIO_CONTROL_WIN_SIZE			34u
#define GENSIO_CONTROL_START_DIRECTORY		35u
#define GENSIO_CONTROL_IN_RATE			36u
#define GENSIO_CONTROL_OUT_RATE			37u
#define GENSIO_CONTROL_IN_BUFSIZE		38u
#define GENSIO_CONTROL_OUT_BUFSIZE		39u
#define GENSIO_CONTROL_IN_NR_CHANS		40u
#define GENSIO_CONTROL_OUT_NR_CHANS		41u
#define GENSIO_CONTROL_IN_FORMAT		42u
#define GENSIO_CONTROL_OUT_FORMAT		43u
#define GENSIO_CONTROL_DRAIN_COUNT		44u

#define GENSIO_CONTROL_SER_MODEMSTATE		45u
#define GENSIO_CONTROL_SER_FLOWCONTROL_STATE	46u
#define GENSIO_CONTROL_SER_FLUSH		47u
#define GENSIO_CONTROL_SER_SEND_BREAK		48u
#define GENSIO_CONTROL_SER_LINESTATE		49u

/* Keep the async control number in a different range, just to be safe. */
#define GENSIO_ACONTROL_SER_BAUD		1000u
#define GENSIO_ACONTROL_SER_DATASIZE		1001u
#define GENSIO_ACONTROL_SER_PARITY		1002u
#define GENSIO_ACONTROL_SER_STOPBITS		1003u
#define GENSIO_ACONTROL_SER_FLOWCONTROL		1004u
#define GENSIO_ACONTROL_SER_IFLOWCONTROL	1005u
#define GENSIO_ACONTROL_SER_SBREAK		1006u
#define GENSIO_ACONTROL_SER_DTR			1007u
#define GENSIO_ACONTROL_SER_RTS			1008u
#define GENSIO_ACONTROL_SER_CTS			1009u
#define GENSIO_ACONTROL_SER_DCD_DSR		1010u
#define GENSIO_ACONTROL_SER_RI			1011u
#define GENSIO_ACONTROL_SER_SIGNATURE		1012u

#define GENSIO_ACC_CONTROL_LADDR	1u
#define GENSIO_ACC_CONTROL_LPORT	2u

/*
 * Get/set the tcpdname option for the gensio dynamically.
 */
#define GENSIO_ACC_CONTROL_TCPDNAME	3u

#endif /* GENSIO_CONTROL_H */
