use core:io;
use core:asm;
use progvis:lang:cpp;

// Print a string to the GUI.
void printStr(Str str) {
	progvis:program:output(str);
	// stdOut.write(str);
	// stdOut.flush();
}

// Simple print function used in some examples:
void print(Int v) {
	printStr(v.toS);
}

// Standard putchar function.
void putchar(Byte ch) {
	printStr(Char(ch.nat).toS);
}

// Not really a part of the C standard. We have this for convenience. It does not output a newline.
void putstr(ConstPtr<Byte> chars) {
	var s = toStorm(chars);
	printStr(s);
}

void puts(ConstPtr<Byte> chars) {
	putstr(chars);
	putchar(10);
}
